/*
 * Decompiled with CFR 0.152.
 */
package com.anvisics.jleveldb;

import com.anvisics.jleveldb.LevelDBAccess;
import com.anvisics.jleveldb.ext.DBAccessor;
import com.anvisics.jleveldb.ext.DBIterator;
import com.anvisics.jleveldb.ext.DBTable;
import com.anvisics.jleveldb.ext.DBTableBuilder;
import com.anvisics.jleveldb.ext.DBWriteBatch;
import com.anvisics.jleveldb.ext.Options;
import com.anvisics.jleveldb.ext.ReadOptions;
import com.anvisics.jleveldb.ext.Status;
import com.anvisics.jleveldb.ext.WriteOptions;
import java.io.File;

public class TestDBAccess {
    private static File f1 = new File("/home/victor/projects/JavaLevelDB/db");
    private static File f3 = new File("/home/victor/projects/JavaLevelDB/table2");
    private static File f2 = new File("/home/victor/projects/JavaLevelDB/table");

    public static void main(String[] stringArray) {
        LevelDBAccess.load();
        TestDBAccess.testSimple();
        TestDBAccess.testBatchUpdateAndIterator();
        TestDBAccess.testTableBuilder();
    }

    private static void assertTrue(boolean bl, String string) {
        if (!bl) {
            throw new IllegalArgumentException(string);
        }
    }

    private static void testSimple() {
        DBAccessor dBAccessor = LevelDBAccess.getDBAcessor();
        f1.mkdirs();
        Options options = new Options();
        options.setCreateIfMissing(true);
        Status status = dBAccessor.open(options, f1.getAbsolutePath());
        System.out.println("Open file ok - " + status.ok());
        TestDBAccess.assertTrue(status.ok(), "File not opened");
        WriteOptions writeOptions = new WriteOptions();
        ReadOptions readOptions = new ReadOptions();
        readOptions.setVerifyChecksums(true);
        readOptions.setFillCache(true);
        dBAccessor.put(writeOptions, "1", "2");
        System.out.println("Put(1) : '2' - " + dBAccessor.getLastStatus().ok());
        String string = dBAccessor.get(readOptions, "1");
        System.out.println("Get(1) : '" + string + "' - " + dBAccessor.getLastStatus().ok());
        string = dBAccessor.get(readOptions, "2");
        System.out.println("Get(2) : '" + string + "' - " + dBAccessor.getLastStatus().ok());
        dBAccessor.remove(writeOptions, "1");
        string = dBAccessor.get(readOptions, "1");
        System.out.println("After delete Get(1) : '" + string + "' - " + dBAccessor.getLastStatus().ok());
        dBAccessor.delete();
        System.out.println("-------\n");
    }

    private static void testBatchUpdateAndIterator() {
        DBAccessor dBAccessor = LevelDBAccess.getDBAcessor();
        f3.mkdirs();
        Options options = new Options();
        options.setCreateIfMissing(true);
        Status status = dBAccessor.open(options, f3.getAbsolutePath());
        System.out.println("Open file ok - " + status.ok());
        TestDBAccess.assertTrue(status.ok(), "File not opened");
        WriteOptions writeOptions = new WriteOptions();
        ReadOptions readOptions = new ReadOptions();
        readOptions.setVerifyChecksums(true);
        readOptions.setFillCache(true);
        DBWriteBatch dBWriteBatch = new DBWriteBatch();
        System.out.println("Store from 5-1000 key^2 to db.");
        for (int i = 5; i < 1000; ++i) {
            dBWriteBatch.Put(i + "", i * i + "");
        }
        dBAccessor.write(writeOptions, dBWriteBatch);
        DBIterator dBIterator = dBAccessor.newIterator(readOptions);
        dBIterator.seekToFirst();
        int n = 0;
        while (dBIterator.valid()) {
            dBIterator.next();
            ++n;
        }
        System.out.println("Values in db : " + n);
        dBAccessor.delete();
        System.out.println("-------\n");
    }

    private static void testTableBuilder() {
        f2.getParentFile().mkdirs();
        Options options = new Options();
        options.setCreateIfMissing(true);
        DBTableBuilder dBTableBuilder = new DBTableBuilder(options);
        Status status = dBTableBuilder.open(f2.getAbsolutePath());
        System.out.println(status.ToString());
        TestDBAccess.assertTrue(status.ok(), "File not opened");
        for (int i = 0; i < 1000; ++i) {
            dBTableBuilder.add("" + i, "" + i * i);
        }
        dBTableBuilder.flush();
        dBTableBuilder.finish();
        System.out.println("Finish creating table");
        DBTable dBTable = DBTable.open(options, f2.getAbsolutePath(), f2.length());
        DBIterator dBIterator = dBTable.newIterator(new ReadOptions());
        dBIterator.seekToFirst();
        int n = 0;
        while (dBIterator.valid()) {
            dBIterator.next();
            ++n;
        }
        System.out.println("Values in db : " + n);
        dBTable.delete();
        System.out.println("-------\n");
    }
}

